#pragma once

#include "BaseShader.h"

using namespace std;
using namespace DirectX;

//Shader used to cull geometry on the specified side of the positioned clip plane - used for water reflection and refraction
class ClipPlaneShader : public BaseShader
{
	public:
		struct ClipPlaneBufferType
		{
			XMFLOAT4 clipPlane;	//Position of the clip plane
		};

		ClipPlaneShader(ID3D11Device* device, HWND hwnd);
		~ClipPlaneShader();

		void setShaderParameters(ID3D11DeviceContext* deviceContext, const XMMATRIX &world, const XMMATRIX &view, const XMMATRIX &projection, ID3D11ShaderResourceView* texture, XMFLOAT4 clipPlane);

		private:
			void initShader(const wchar_t* vs, const wchar_t* ps);

		private:
			ID3D11Buffer* matrixBuffer;
			ID3D11Buffer* clipPlaneBuffer;
			ID3D11SamplerState* sampleState;
};

